/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.internal.parsing.ParserPool;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParserPool;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParsingEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserPoolFactory
implements ParsingEngine.IParserPoolProvider {
    private static final String PARSER_ID = "parser";
    private static final String ELEMENT_PARSER = "parser";
    private static final String ATTR_CONTENT_TYPE = "content-type";
    private static ParserPoolFactory INSTANCE;
    private Map<String, IConfigurationElement> parsers;
    private Map<String, IParserPool> pools;
    private final ParsingEngine fParsingEngine = new ParsingEngine(this);

    public static synchronized ParserPoolFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParserPoolFactory();
        }
        return INSTANCE;
    }

    private static Map<String, IConfigurationElement> getParsers() {
        final HashMap<String, IConfigurationElement> parsers = new HashMap<String, IConfigurationElement>();
        EclipseUtil.processConfigurationElements((String)"com.aptana.parsing", (String)"parser", (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String contentType = element.getAttribute(ParserPoolFactory.ATTR_CONTENT_TYPE);
                parsers.put(contentType, element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{"parser"});
            }
        });
        return parsers;
    }

    private ParserPoolFactory() {
    }

    synchronized void dispose() {
        this.fParsingEngine.dispose();
        if (this.pools != null) {
            for (Map.Entry<String, IParserPool> entry : this.pools.entrySet()) {
                IParserPool pool = entry.getValue();
                pool.dispose();
            }
            this.pools.clear();
            this.pools = null;
        }
        if (this.parsers != null) {
            this.parsers.clear();
            this.parsers = null;
        }
    }

    @Override
    public synchronized IParserPool getParserPool(String contentTypeId) {
        IContentTypeManager ctm = Platform.getContentTypeManager();
        IContentType contentType = ctm.getContentType(contentTypeId);
        IParserPool result = null;
        if (this.pools == null) {
            this.pools = new HashMap<String, IParserPool>();
        }
        while (result == null && (contentType != null || contentTypeId != null)) {
            IConfigurationElement parserExtension;
            if (contentType != null) {
                contentTypeId = contentType.getId();
            }
            if ((result = this.pools.get(contentTypeId)) != null) continue;
            if (this.parsers == null) {
                this.parsers = ParserPoolFactory.getParsers();
            }
            if ((parserExtension = this.parsers.get(contentTypeId)) != null) {
                result = new ParserPool(parserExtension);
                this.pools.put(contentTypeId, result);
                continue;
            }
            if ((contentType = contentType.getBaseType()) == null) break;
        }
        return result;
    }

    public static ParseResult parse(String contentTypeId, String source, int startingOffset) throws Exception {
        return ParserPoolFactory.parse(contentTypeId, source, startingOffset, null);
    }

    public static ParseResult parse(String contentTypeId, String source) throws Exception {
        return ParserPoolFactory.parse(contentTypeId, source, 0, null);
    }

    public static ParseResult parse(String contentTypeId, String source, int startingOffset, IProgressMonitor monitor) throws Exception {
        ParseState parseState = new ParseState(source, startingOffset);
        parseState.setProgressMonitor(monitor);
        return ParserPoolFactory.parse(contentTypeId, parseState);
    }

    public static ParseResult parse(String contentTypeId, IParseState parseState) throws Exception {
        return ParserPoolFactory.getInstance().fParsingEngine.parse(contentTypeId, parseState);
    }

    public void clearCache() {
        this.fParsingEngine.clearCache();
    }
}

